<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;

class FactTypeDocumentMother
{

    public static function pushDefault()
    {
        return self::push(self::build1(IdFactTypeDocument::defaultValue()));
    }
    
    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_FactTypeDocument' => $id,
            'FactTypeDocument_Name' => $faker->text(rand(5, 100)),
            'FactTypeDocument_Abrv' => Util::generateString(10),
            'FactTypeDocument_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_type_document`(`Id_FactTypeDocument`,`FactTypeDocument_Name`, `FactTypeDocument_Abrv`, `FactTypeDocument_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_FactTypeDocument'] == 0 ? null : $object['Id_FactTypeDocument'],
            $object['FactTypeDocument_Name'],
            $object['FactTypeDocument_Abrv'],
            $object['FactTypeDocument_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactTypeDocument'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::FACT_TYPE_DOCUMENT ];
    }
}
