<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class FactReceiptMother
{

    public static function build1($idFactTypeReceipt = null, $idFactTypeDocument = null, $idCashMovement = null, $id = 1)
    {
        $idFactTypeReceipt = $idFactTypeReceipt ?? FactTypeReceiptMother::push1()['Id_FactTypeReceipt'];
        $idFactTypeDocument = $idFactTypeDocument ?? FactTypeDocumentMother::push1()['Id_FactTypeDocument'];
        $idTypePayment = $idTypePayment ?? TypePaymentMother::push1()['Id_TypePayment'];
        $idFactPaymentMethod = $idFactPaymentMethod ?? FactPaymentMethodMother::push1()['Id_FactPaymentMethod'];
        $idFactCurrency = $idFactCurrency ?? FactCurrencyMother::push1()['Id_FactCurrency'];
        $faker = Factory::create();
        return [
            'Id_FactReceipt' => $id,
            'FactReceipt_Date' => $faker->dateTime()->format('Y-m-d H:i:s'),
            'FactReceipt_DateUpdate' => $faker->dateTime()->format('Y-m-d H:i:s'),
            'FactReceipt_DateEmission' => $faker->date(),
            'FactReceipt_NoDocument' => $faker->text(rand(5, 250)),
            'FactReceipt_BusinessName' => $faker->text(rand(5, 250)),
            'FactReceipt_Email' => $faker->email,
            'FactReceipt_Address' => $faker->text(rand(5, 500)),
            'FactReceipt_LicensePlate' => $faker->text(rand(5, 250)),
            'FactReceipt_Currency' => $faker->text(rand(5, 10)),
            'FactReceipt_ResponseMessage' => $faker->text(rand(5, 500)),
            'FactReceipt_Status' => $faker->randomElement([1, 2]),
            'Id_FactTypeReceipt' => $idFactTypeReceipt,
            'Id_FactTypeDocument' => $idFactTypeDocument,
            'Id_FactPaymentMethod' => $idFactPaymentMethod,
            'Id_FactCurrency' => $idFactCurrency,
            'Id_CashMovement' => $idCashMovement,
        ];
    }

    public static function push1($idFactTypeReceipt = null, $idFactTypeDocument = null, $idCashMovement = null, $id = 1)
    {
        return self::push(self::build1($idFactTypeReceipt, $idFactTypeDocument, $idCashMovement, $id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_receipt`(
            `FactReceipt_Date`,
            `FactReceipt_DateUpdate`,
            `FactReceipt_DateEmission`,
            `FactReceipt_NoDocument`,
            `FactReceipt_BusinessName`,
            `FactReceipt_Email`,
            `FactReceipt_Address`,
            `FactReceipt_LicensePlate`,
            `FactReceipt_Currency`,
            `FactReceipt_ResponseMessage`,
            `FactReceipt_Status`,
            `Id_FactTypeReceipt`,
            `Id_FactTypeDocument`,
            `Id_FactPaymentMethod`,
            `Id_FactCurrency`
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['FactReceipt_Date'],
            $object['FactReceipt_DateUpdate'],
            $object['FactReceipt_DateEmission'],
            $object['FactReceipt_NoDocument'],
            $object['FactReceipt_BusinessName'],
            $object['FactReceipt_Email'],
            $object['FactReceipt_Address'],
            $object['FactReceipt_LicensePlate'],
            $object['FactReceipt_Currency'],
            $object['FactReceipt_ResponseMessage'],
            $object['FactReceipt_Status'],
            $object['Id_FactTypeReceipt'],
            $object['Id_FactTypeDocument'],
            $object['Id_FactPaymentMethod'],
            $object['Id_FactCurrency']
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactReceipt'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TableCreation::FACT_RECEIPT, ...FactTypeReceiptMother::tablesToClear(), ...FactTypeDocumentMother::tablesToClear()];
    }
}
