<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class FactPaymentMethodMother
{

    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_FactPaymentMethod' => $id,
            'FactPaymentMethod_Name' => $faker->text(rand(5, 250)),
            'FactPaymentMethod_Abrv' => Util::generateString(10),
            'FactPaymentMethod_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_payment_method`(`Id_FactPaymentMethod`, `FactPaymentMethod_Name`, `FactPaymentMethod_Abrv`, `FactPaymentMethod_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_FactPaymentMethod'] == 0 ? null : $object['Id_FactPaymentMethod'],
            $object['FactPaymentMethod_Name'],
            $object['FactPaymentMethod_Abrv'],
            $object['FactPaymentMethod_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactPaymentMethod'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::FACT_PAYMENT_METHOD];
    }
}
