<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class FactCurrencyMother
{

    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_FactCurrency' => $id,
            'FactCurrency_Name' => $faker->text(rand(5, 250)),
            'FactCurrency_Abrv' => Util::generateString(10),
            'FactCurrency_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_currency`(`Id_FactCurrency`, `FactCurrency_Name`, `FactCurrency_Abrv`, `FactCurrency_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_FactCurrency'] == 0 ? null : $object['Id_FactCurrency'],
            $object['FactCurrency_Name'],
            $object['FactCurrency_Abrv'],
            $object['FactCurrency_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactCurrency'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::FACT_CURRENCY];
    }
}
