<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingTourPassengerMother
{
    public static function build1($Id_BookingTour, $Id_Passenger, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_BookingTourPassenger' => $id,
            'BookingTourPassenger_Status' => $faker->randomElement([1, 2]),
            'Id_BookingTour' => $Id_BookingTour,
            'Id_Passenger' => $Id_Passenger
        ];
    }

    public static function push1($Id_BookingTour, $Id_Passenger, $id = 1)
    {
        return self::push(self::build1($Id_BookingTour, $Id_Passenger, $id));
    }

    private static function push($object)
    {
        $amount = count(DB::select('SELECT * FROM t_booking_tour_passenger WHERE Id_BookingTour=?', [$object['Id_BookingTour']]));
        $response = DB::select("CALL `sp_booking_tour_passenger_insert`(?,?,?)", [
            $object['Id_BookingTour'],
            $object['Id_Passenger'],
            $amount + 1
        ]);

        $object['Id_BookingTourPassenger'] = $response[0]->Response_Id;

        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_BOOKING_TOUR_PASSENGER],
            BookingMother::clear(),
            PassengerMother::tablesToClear(),
        );
    }
}
