<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class BookingTourMother
{

    public static function buildShared1($Id_Booking, $Id_Package, $Id_Tour, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_BookingTour' => $id,
            'BookingTour_DateStart' => date('Y-m-d'),
            'BookingTour_PickUp' => date('H:m:s'),
            'BookingTour_Type' => 3,
            'BookingTour_Type' => 1,
            'BookingTour_NoPax' => 2,
            'BookingTour_Name' => '',
            'BookingTour_TourName' => '',
            'BookingTour_FeeType' => $faker->randomElement([1, 2]),
            'BookingTour_Full' => $faker->randomNumber(8),
            'BookingTour_MinimumFull' => $faker->randomNumber(8),
            'BookingTour_Group' => 1,
            'BookingTour_TourDuration' => 5,
            'BookingTour_Status' => 2,
            'Id_Booking' => $Id_Booking,
            'Id_Package' => $Id_Package,
            'Id_Tour' => $Id_Tour
        ];
    }

    public static function pushShared1($Id_Booking, $Id_Package, $Id_Tour, $id = 1)
    {
        return self::push(self::buildShared1($Id_Booking, $Id_Package, $Id_Tour, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_booking_tour_insert` (?,?,?,?,?,?,?,?,?)", [
            $object['BookingTour_DateStart'],
            $object['BookingTour_Type'],
            $object['BookingTour_NoPax'],
            $object['BookingTour_FeeType'],
            $object['BookingTour_Full'],
            $object['Id_Package'],
            $object['Id_Booking'],
            $object['Id_Tour'],
            $object['BookingTour_Group']
        ]);
        $object['Id_BookingTour'] = DB::select('SELECT LAST_INSERT_ID() AS `Id`')[0]->Id;
        return $object;
    }
}
