<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingExtraPassengerMother
{
    public static function build1($Id_Admin, $Id_BookingExtra, $Id_BookingTourPassenger, $id = 1)
    {
        $faker = \Faker\Factory::create();
        return [
            'Id_BookingExtraPassenger' => $id,
            'BookingExtraPassenger_Date' => date('Y-m-d H:i:s'),
            'BookingExtraPassenger_DateEntryStart' => date('Y-m-d H:i', time() + rand(100000, 1000000)),
            'BookingExtraPassenger_DateEntryEnd' => date('Y-m-d H:i', time() + rand(100000, 1000000)),
            'BookingExtraPassenger_DatePurchase' => date('Y-m-d', time() + rand(100000, 1000000)),
            'BookingExtraPassenger_Code' => Util::generateString(20),
            'BookingExtraPassenger_Amount' => $faker->randomNumber(4),
            'BookingExtraPassenger_Remark' => $faker->text(rand(5, 250)),
            'BookingExtraPassenger_Status' => 1,
            'Id_Admin' => $Id_Admin,
            'Id_BookingExtra' => $Id_BookingExtra,
            'Id_BookingTourPassenger' => $Id_BookingTourPassenger
        ];
    }

    public static function push1($Id_Admin, $Id_BookingExtra, $Id_BookingTourPassenger, $id = 1)
    {
        return self::push(self::build1($Id_Admin, $Id_BookingExtra, $Id_BookingTourPassenger, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_booking_extra_passenger_insert`(?,?,?)", [
            $object['Id_BookingExtra'],
            $object['Id_BookingTourPassenger'],
            1
        ]);
        $object['Id_BookingExtraPassenger'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            BookingMother::clear(),
            [
                TC::TYPE_EXTRA,
                TC::TYPE_EXTRA_TRANSL,
                TC::EXTRA,
                TC::EXTRA_TRANSL,
                TC::BOOKING_EXTRA,
                TC::BOOKING_EXTRA_PASSENGER,
                ...BookingMother::clear()
            ]
        );
    }
}
