<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingAdditionalMother
{
    public static function build1($id = 1)
    {
        $faker = \Faker\Factory::create();
        return [
            'Id_BookingAdditional' => $id
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_booking_extra_passenger_insert`(?,?,?)", [
            $object['Id_BookingExtra'],
            $object['Id_BookingTourPassenger'],
            1
        ]);
        $object['Id_BookingAdditional'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            [
                TC::BOOKING_ADDITIONAL,
            ]
        );
    }
}
