<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;
use App\Modules\WebContactMessageDetail\Infraestructure\MysqlWebContactMessageDetailRepository;

$app->bind(WebContactMessageDetailRepository::class, fn($app) => $app->make(MysqlWebContactMessageDetailRepository::class));

$router->post(
    '/webContactMessageDetail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessageDetail\\WebContactMessageDetailInsertController@__invoke'
    ]
);

$router->put(
    '/webContactMessageDetail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessageDetail\\WebContactMessageDetailUpdateController@__invoke'
    ]
);

$router->delete(
    '/webContactMessageDetail/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessageDetail\\WebContactMessageDetailDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/webContactMessageDetail/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessageDetail\\WebContactMessageDetailIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/webContactMessage/{Id_WebContact}/webContactMessageDetail/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessageDetail\\WebContactMessageDetailListController@__invoke'
    ]
)->where(['Id_WebContact' => '[0-9]*']);
