<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignRepository;
use App\Modules\TypeBookingAssign\Infraestructure\MysqlTypeBookingAssignRepository;

$app->bind(TypeBookingAssignRepository::class, fn($app) => $app->make(MysqlTypeBookingAssignRepository::class));

$router->post(
    '/typeBookingAssign',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TypeBookingAssign\\TypeBookingAssignInsertController@__invoke'
    ]
);

$router->put(
    '/typeBookingAssign',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TypeBookingAssign\\TypeBookingAssignUpdateController@__invoke'
    ]
);

$router->delete(
    '/typeBookingAssign/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TypeBookingAssign\\TypeBookingAssignDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/typeBookingAssign/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TypeBookingAssign\\TypeBookingAssignIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/typeBookingAssign/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'TypeBookingAssign\\TypeBookingAssignListController@__invoke'
    ]
);
