<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\StatusGroup\Domain\StatusGroupRepository;
use App\Modules\StatusGroup\Infraestructure\MysqlStatusGroupRepository;

$app->bind(StatusGroupRepository::class, fn($app) => $app->make(MysqlStatusGroupRepository::class));

$router->post(
    '/statusGroup',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroup\\StatusGroupInsertController@__invoke'
    ]
);

$router->put(
    '/statusGroup',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroup\\StatusGroupUpdateController@__invoke'
    ]
);

$router->delete(
    '/statusGroup/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroup\\StatusGroupDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/statusGroup/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroup\\StatusGroupIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/statusGroup/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'StatusGroup\\StatusGroupListController@__invoke'
    ]
);
