<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/paxInformationPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_PaxInformationPassenger@Insert'
    ]
);

$router->put(
    '/paxInformationPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_PaxInformationPassenger@Update'
    ]
);

$router->delete(
    '/paxInformationPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_PaxInformationPassenger@Delete'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/paxInformationPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_PaxInformationPassenger@Index'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/paxInformation/{Id_PaxInformation}/paxInformationPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_PaxInformationPassenger@List'
    ]
)->where('Id_PaxInformation', '[0-9]*');
