<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;
use App\Modules\LeadBookingService\Infraestructure\MysqlLeadBookingServiceRepository;

$router->post(
    '/leadBookingService',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingService',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingService/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingService/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBookingTour/{Id_LeadBookingTour}/leadBookingService/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceListController@__invoke'
    ]
)->where('Id_LeadBookingTour', '[0-9]*');

$app->bind(LeadBookingServiceRepository::class, fn($app) => $app->make(MysqlLeadBookingServiceRepository::class));
