<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBooking\Domain\LeadBookingRepository;
use App\Modules\LeadBooking\Infraestructure\MysqlLeadBookingRepository;

$app->bind(LeadBookingRepository::class, fn($app) => $app->make(MysqlLeadBookingRepository::class));

$router->post(
    '/leadBooking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingInsertController@__invoke'
    ]
);

$router->put(
    '/leadBooking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBooking/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBooking/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBooking/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBooking\\LeadBookingListController@__invoke'
    ]
);
