<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlRoom\Domain\HtlRoomRepository;
use App\Modules\HtlRoom\Infraestructure\MysqlHtlRoomRepository;

$app->bind(HtlRoomRepository::class, fn ($app) => $app->make(MysqlHtlRoomRepository::class));

$router->post(
    '/htlRoom',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlRoom@Insert'
    ]
);

$router->put(
    '/htlRoom',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlRoom@Update'
    ]
);

$router->delete(
    '/htlRoom/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlRoom@Delete'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlRoom/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlRoom@Index'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlCamp/{Id_HtlCamp}/htlRoom/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_HtlRoom@List'
    ]
)->where('Id_HtlCamp', '[0-9]*');
