<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\GroupProvider\Domain\GroupProviderReportRepository;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Infraestructure\MysqlGroupProviderReportRepository;
use App\Modules\GroupProvider\Infraestructure\MysqlGroupProviderRepository;

$app->bind(GroupProviderRepository::class, fn ($app) => $app->make(MysqlGroupProviderRepository::class));
$app->bind(GroupProviderReportRepository::class, fn ($app) => $app->make(MysqlGroupProviderReportRepository::class));

$router->get(
    '/groupProvider/reviews/excel',
    [
        'uses' => 'GroupProvider\\GroupProviderReviewExportToExcelController@__invoke'
    ]
);

$router->post(
    '/groupProvider/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\InsertAll@__invoke'
    ]
);

$router->post(
    '/groupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@insert'
    ]
);

$router->put(
    '/groupProvider/mask',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\GroupProviderMaskController@__invoke'
    ]
);

$router->put(
    '/groupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\Update@__invoke'
    ]
);

$router->put(
    '/groupProvider/remark',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@remark'
    ]
);

$router->delete(
    '/groupProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@delete'
    ]
);

$router->get(
    '/groupProvider/gallery/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\GroupProviderListGalleryController@__invoke'
    ]
);

$router->get(
    '/groupProvider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@index'
    ]
);

$router->get(
    '/group/{Id_Group}/groupProvider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@list'
    ]
);

$router->get(
    '/group/{Id_Group}/groupProvider/full',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider@listFull'
    ]
);

$router->put(
    '/groupProvider/{Id_GroupProvider}/mediaStatus',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\GroupProviderUploadMediaController@__invoke'
    ]
)->where('Id_GroupProvider', '[0-9]*');

$router->put(
    '/groupProvider/{Id_GroupProvider}/mediaScore',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProvider\\GroupProviderUpdateScoreController@__invoke'
    ]
)->where('Id_GroupProvider', '[0-9]*');

$router->get(
    '/groupProvider/{Id_GroupProvider}/downloadMedia',
    [
        'middleware' => 'Auth_Owner_Url',
        'uses' => 'GroupProvider\\GroupProviderDownloadMediaController@__invoke'
    ]
)->where('Id_GroupProvider', '[0-9]*');
