<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaRepository;
use App\Modules\GroupPassengerMedia\Infrastructure\MysqlGroupPassengerMediaRepository;
use App\Modules\Media\Domain\FileReceptor;
use App\Modules\Media\Domain\ImageThumbnailCreator;
use App\Modules\Media\Domain\MediaRepository;
use App\Modules\Media\Domain\VideoThumbnailCreator;
use App\Modules\Media\Infrastructure\LaravelFileReceptor;
use App\Modules\Media\Infrastructure\MemoryImageThumbnailCreator;
use App\Modules\Media\Infrastructure\MemoryMediaRepository;
use App\Modules\Media\Infrastructure\MemoryVideoThumbnailCreator;

$app->bind(MediaRepository::class, fn ($app) => $app->make(MemoryMediaRepository::class));
$app->bind(GroupPassengerMediaRepository::class, fn ($app) => $app->make(MysqlGroupPassengerMediaRepository::class));
$app->bind(VideoThumbnailCreator::class, fn ($app) => $app->make(MemoryVideoThumbnailCreator::class));
$app->bind(ImageThumbnailCreator::class, fn ($app) => $app->make(MemoryImageThumbnailCreator::class));
$app->bind(FileReceptor::class, fn ($app) => $app->make(LaravelFileReceptor::class));

$router->post(
    '/groupPassengerMedia',
    [
        'uses' => 'GroupPassengerMedia\\GroupPassengerMediaInsertController@__invoke'
    ]
);

$router->get(
    '/groupPassengerMedia/{Id}',
    [
        'uses' => 'GroupPassengerMedia\\GroupPassengerMediaIndexController@__invoke'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/groupPassengerMedia/{Id}/download',
    [
        'uses' => 'GroupPassengerMedia\\GroupPassengerMediaDownloadIndexController@__invoke'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/groupPassenger/{Id_GroupPassenger}/groupPassengerMedia/{Action}',
    [
        'uses' => 'GroupPassengerMedia\\GroupPassengerMediaListController@__invoke'
    ]
)->where('Id_GroupPassenger', '[0-9]*');
