<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactTypeDocument\Domain\FactTypeDocumentRepository;
use App\Modules\FactTypeDocument\Infraestructure\MysqlFactTypeDocumentRepository;

$app->bind(FactTypeDocumentRepository::class, fn($app) => $app->make(MysqlFactTypeDocumentRepository::class));

$router->put(
    '/factTypeDocument',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeDocument\\FactTypeDocumentUpdateController@__invoke'
    ]
);

$router->get(
    '/factTypeDocument/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeDocument\\FactTypeDocumentIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factTypeDocument/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeDocument\\FactTypeDocumentListController@__invoke'
    ]
);
