<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingCalendar\Domain\BookingCalendarRepository;
use App\Modules\BookingCalendar\Infrastructure\MysqlBookingCalendarRepository;

$app->bind(BookingCalendarRepository::class, fn($app) => $app->make(MysqlBookingCalendarRepository::class));

$router->get(
    '/bookingCalendar',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Calendar\\BookingCalendarController@__invoke'
    ]
);

$router->get(
    '/bookingCalendar/passenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Calendar\\BookingCalendarPassengerController@__invoke'
    ]
);
