<?php
use App\Http\Controllers\Mail\c_Mail_Body;
use App\Http\Controllers\Mail\c_Mail_Table;
use App\Http\Controllers\Mail\c_Mail_Term;

$oMail_Body = new c_Mail_Body;
$oMail_Term = new c_Mail_Term;

$passengers          = $Content['Passenger'];
$term			= $oMail_Term->Get_Term($Content["Lang"]);

$title          = 'Review Report';

$Mail_Body 		= $oMail_Body->Get_Body();
$Mail_Content   = '';
$Mail_Content   .= $oMail_Body->Get_H1($title);

foreach ($passengers as $pax) {
    $name           = str_replace('[[PAX_NAME]]', $pax->Passenger_Name . ' ' . $pax->Passenger_LastName, $term['Passenger_Name']);
    $email          = str_replace('[[PAX_EMAIL]]', $pax->Passenger_Email, $term['Passenger_Email']);
    $phone          = str_replace('[[PAX_PHONE]]', $pax->Passenger_Phone, $term['Passenger_Phone']);
    $Mail_Content   .= $oMail_Body->Get_P($name,"LEFT");
    $Mail_Content   .= $oMail_Body->Get_P($email,"LEFT");
    $Mail_Content   .= $oMail_Body->Get_P($phone,"LEFT");

    foreach ($pax->Review as $review) {
        $Mail_Content .= $oMail_Body->Get_P(createReviewTable($review), 'LEFT');
    }
}

function createReviewTable($review) {

    $userTable = c_Mail_Table::table();

    $userTable
        ->basicRow([
            c_Mail_Table::baseColumn('TOUR')->setBold()->setWidth('150px'),
            c_Mail_Table::baseColumn ($review->Tour_Name)
        ])
        ->basicRow ([
            c_Mail_Table::baseColumn('PREGUNTA')->setBold(),
            c_Mail_Table::baseColumn ($review->Question_Name)
        ])
        ->basicRow ([
            c_Mail_Table::baseColumn('SCORE')->setBold(),
            c_Mail_Table::baseColumn ($review->PassengerReview_Score)
        ])
        ->basicRow ([
            c_Mail_Table::baseColumn('COMENTARIO')->setBold(),
            c_Mail_Table::baseColumn ($review->PassengerReview_Comment)
        ]);
    return $userTable;
}

$Mail_Body      = str_replace("[[CONTENT]]", $Mail_Content, $Mail_Body);
$Mail_Body      = str_replace("[[MEDIA_HEADER]]", $Content["ResourcesUrl"] . 'mail/Mail_Header.png', $Mail_Body);
echo $Mail_Body;