<?php

use App\Http\Constants\BookingConstants;
use App\Http\Controllers\Mail\c_Mail_Cash_Movement_Body;
use App\Http\Controllers\Mail\c_Mail_Structure;
use App\Http\Controllers\Mail\c_Mail_Term;
use App\Http\Controllers\Mail\c_Mail_Table;
use App\Http\Helpers\CashMovementHelper;
use App\Http\Helpers\DateTime;
use App\Providers\UserBooking\BookingTypeImage;

$oMail_Body = new c_Mail_Cash_Movement_Body;
$oMail_Structure = new c_Mail_Structure;
$oMail_Term = new c_Mail_Term;

$HeadFunction = function ($head) use ($oMail_Body) {
    return $oMail_Body->Get_Head($oMail_Body->Get_H4_2($head));
};
$CellFunction = function ($cell) use ($oMail_Body) {
    return $oMail_Body->Get_Cell($oMail_Body->Get_P($cell, 'LEFT'));
};

$PrintObligatory = function ($fee) {
    return $fee->InvoiceFee_Full == 2 && $fee->InvoiceFee_Amount - $fee->InvoiceFee_AmountPay > 0;
};

$booking = $Content['Booking'];

//
//  OBTENEMOS TERMINOS EN UN IDIOMA
//
$Term               = $oMail_Term->Get_Term($Content["Lang"]);


$title              = $Term["CashMovement_Title"];
$transactionCode    = $Term["CashMovement_TransactionCode"];
$cardNumber         = $Term["CashMovement_CardNumber"];
$fullName           = $Term["CashMovement_FullName"];
$amount             = $Term["CashMovement_Amount"];
$bookingCode        = $Term["CashMovement_BookingCode"];
$itinerary          = $Term["CashMovement_Itinerary"];
$deposits           = $Term["CashMovement_Deposits"];
$total              = $Term["CashMovement_Total"];
$balance            = $Term["CashMovement_Balance"];

$Signature          = $Term["Signature"];

$Mail_Body      = $oMail_Body->Get_Booking_Body();
$Mail_Content   = $oMail_Body->Get_P_2($title, 'CENTER');
// $Mail_Content   = $oMail_Body->Get_P_2($title, 'LEFT');
$Mail_Content   .= $oMail_Body->Get_P_2($bookingCode, "CENTER");
$Mail_Content   .= $oMail_Body->Get_P_2($booking->Booking_Code, "CENTER");

$assets = BookingTypeImage::getAssetValue($booking);
$urlType = $assets['asset'];

$booking->Tour  = array_values(array_filter($booking->Tour, fn($t) => $t->BookingTour_Status == 2));
$Mail_Content   .= createTourTable($booking);
$Mail_Content   .= $oMail_Body->Get_P(' ', 'LEFT');
$Mail_Content   .= createTourInformationTable($booking->InvoiceDetailAll, $booking);

function createCashMovementCode($booking, $transactionCode, $cardNumber, $fullName, $amount)
{
    $tourTable = c_Mail_Table::table();
    $tourTable->borderWidth = '0px';

    $rows = [];
    $cme = [
        (object)[
            'left' => $transactionCode,
        ],
        (object)[
            'left' => $cardNumber,
        ],
        (object)[
            'left' => $fullName,
        ],
        (object)[
            'left' => $amount,
        ]
    ];
    $rows = array_merge($rows, mapTourList($booking->InvoiceDetailAll, $booking->Tour));

    addToTable($rows, $tourTable, 'unbordered');
    return $tourTable;
}

function mapCashMovementElementList($cme, $tourList)
{
    $tourInfo = [];
    foreach ($cme as $detail) {

        if ($detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypePackage) {

            $tours = array_values(array_filter($tourList, function ($t) use ($detail) {
                return $t->Id_BookingTour == $detail->Id_BookingTour;
            }));

            $tourInfo[] = [
                'x' . $detail->InvoiceDetail_Quantity,
                $detail->InvoiceDetail_Description,
            ];
            $tourInfo[] = [
                '',
                count($tours) ? date('m/d/Y', strtotime($tours[0]->BookingTour_DateStart)) : '',
            ];
        }
    }

    return $tourInfo;
}

function createTourTable($booking)
{
    $tourTable = c_Mail_Table::table();
    $tourTable->borderWidth = '0px';

    $rows = [];
    $rows = array_merge($rows, mapTourList($booking->InvoiceDetailAll, $booking->Tour));

    $tourTable->basicRow([c_Mail_Table::unBorderedColumn('ITINERARY SUMMARY')->setAlign('center')->setColspan(2)->setBold()]);
    addToTable($rows, $tourTable, 'unbordered');
    return $tourTable;
}

function mapTourList($invoiceDetailAll, $tourList)
{
    $tourInfo = [];
    foreach ($invoiceDetailAll as $detail) {

        if ($detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypePackage) {

            $tours = array_values(array_filter($tourList, function ($t) use ($detail) {
                return $t->Id_BookingTour == $detail->Id_BookingTour;
            }));

            $tourInfo[] = [
                'x' . $detail->InvoiceDetail_Quantity,
                $detail->InvoiceDetail_Description,
            ];
            $tourInfo[] = [
                '',
                count($tours) ? date('m/d/Y', strtotime($tours[0]->BookingTour_DateStart)) : '',
            ];
        }
    }

    return $tourInfo;
}

function mapFlightList($flightList)
{
    return array_map(function ($flight) {
        $cell1 = $flight->Flight_Type == 2 ? 'TRANSFER OUT ' : 'TRANSFER IN';
        $cell1 .= "$flight->Flight_Carrier $flight->Flight_Number ($flight->Flight_Origin-$flight->Flight_Destination)";
        return [
            $cell1,
            DateTime::dateTimeTransform($flight->Flight_DateArrival)
        ];
    }, $flightList);
}

function createUserTable($booking)
{

    $userTable = c_Mail_Table::table();

    $userTable
        ->basicRow([
            c_Mail_Table::orangeColumn('Briefing Session')->setFontSize('.8em'),
            c_Mail_Table::baseColumn(bookingSession($booking))
                ->setColspan(3)
                ->setFontSize('.8em')
        ])
        ->basicRow([
            c_Mail_Table::orangeColumn('Contact Name')->setFontSize('.8em'),
            c_Mail_Table::baseColumn("$booking->User_Name $booking->User_LastName")->setFontSize('.8em')
                ->setColspan(3)
                ->setFontSize('.8em'),
        ]);
    return $userTable;
}

function createTourInformationTable($invoiceDetailAll, $booking)
{
    $paxTable = c_Mail_Table::table();
    $paxTable->borderWidth = '0px';

    $paxTable->basicRow([c_Mail_Table::unBorderedColumn('DEPOSITS')->setAlign('center')->setColspan(6)->setBold()]);

    $rows = [];
    $invoiceTotal = 0;

    foreach ($invoiceDetailAll as $detail) {
        if ($detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypePackage) {
            $detail->datePackage = searchMinTourDate($detail->InvoiceDetail_Group, $booking);
        } else {
            $detail->datePackage = '';
        }

        if ($booking->User_Type == BookingConstants::User_TypeEndorser
            && $detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypeIGV
        ) {
            $invoiceTotal += $detail->InvoiceDetail_Total;
        } else {
            $rows[] = [
                !$detail->datePackage ? '' : DateTime::dateTransform($detail->datePackage),
                $detail->InvoiceDetail_Description,
                $detail->InvoiceDetail_Included == 1 ? "" : $detail->InvoiceDetail_Quantity,
                $detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypeIGV ? "" : (round($detail->InvoiceDetail_Price * 100)) / 100,
                $detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypeIGV ? "" : $detail->InvoiceDetail_Quantity,
                round($detail->InvoiceDetail_Total * 100) / 100,
            ];
        }
    }

    $texttot = 'TOTAL';
    $valtot = $booking->InvoiceRes['Total'];
    $rows = 1;
    $obser = '';

    if ($booking->User_Type == 2) {
        $texttot = "Tours Balance";
        $valtot -= $invoiceTotal;
        $rows = 5;
        $obser = "OBSERVACION:" . $booking->Booking_Observation;
    }
    $paxTable->basicRow([
        c_Mail_Table::unBorderedColumn($texttot)->setBold(),
        c_Mail_Table::unBorderedColumn('USD$' . round($valtot * 100) / 100)->setAlign('right')
    ]);

    if ($booking->User_Type == 2) {
        $sumpays = 0;
        foreach ($booking->PayAll as $pay) {
            $sumpays += $pay->CashMovementDetail_Amount;
        }

        $paxTable->basicRow([
            c_Mail_Table::unBorderedColumn('IGV')->setBold(),
            c_Mail_Table::unBorderedColumn('USD$' . round($invoiceTotal * 100) / 100)->setAlign('right')
        ]);
        $paxTable->basicRow([
            c_Mail_Table::unBorderedColumn('Total')->setBold(),
            c_Mail_Table::unBorderedColumn('USD$' . round(($valtot + $invoiceTotal) * 100) / 100)->setAlign('right')
        ]);
    }

    foreach ($booking->PayAll as $pay) {
        $paxTable->basicRow([
            c_Mail_Table::unBorderedColumn("$pay->TypePayment_Name: " .
                CashMovementHelper::changeReceiptNumber($pay) .
                " ($pay->CashMovement_Amount )"
            ),
            c_Mail_Table::unBorderedColumn('USD$' . round($pay->CashMovementDetail_Amount * 100) / 100)->setAlign('right')
        ]);
    }

    $paxTable->basicRow([
        c_Mail_Table::unBorderedColumn("BALANCE")->setBold(),
        c_Mail_Table::unBorderedColumn('USD$' . round($booking->InvoiceRes['TotalPending'] * 100) / 100)->setAlign('right')
    ]);

    return $paxTable;
}

function searchMinTourDate($group, $booking)
{
    return array_reduce($booking->Tour, function ($prev, $tour) use ($group) {
        if ($tour->BookingTour_Group != $group) {
            return $prev;
        }
        if ($prev == null) {
            return $tour->BookingTour_DateStart;
        }

        return (strtotime($prev) < strtotime($tour->BookingTour_DateStart)) ? $prev : $tour->BookingTour_DateStart;
    }, null);
}

function getRoomsResume($roomList)
{
    $roomAmounts = (object) [];
    $text = '';

    foreach ($roomList as $i => $room) {
        $key = $room->Id_TypeRoom;
        if (isset($roomAmounts->$key)) {
            $roomAmounts->$key->count++;
        } else {
            $roomAmounts->$key = (object)[
                'Id_TypeRoom'   => $room->Id_TypeRoom,
                'index'     => $i,
                'count'     => 1
            ];
        }
    }
    $i = 0;
    foreach ($roomAmounts as $key => $amount) {
        $text .= ($i == 0 ? '' : ', ') . str_pad($amount->count, 2, '0', STR_PAD_LEFT) . ' ' . $roomList[$amount->index]->TypeRoom_Name;
        $i++;
    }
    return $text;
}

function bookingSession($booking)
{
    return DateTime::dateTimeTransform($booking->Booking_DateBriefing) . '(' . $booking->Booking_PlaceBriefing . ')';
}

function mapPaxList($paxList)
{
    return array_map(function ($pax) {
        return [
            $pax->Passenger_Name,
            $pax->Passenger_LastName,
            $pax->Passenger_Gender == '1' ? 'M' : 'F',
            DateTime::dateTransform($pax->Passenger_DOB),
            $pax->Passenger_Age,
            $pax->Passenger_NoDocument,
            $pax->UserCountry_Name
        ];
    }, $paxList);
}

function addToTable($rows, &$table, $type = 'base')
{
    foreach ($rows as $row) {
        $tableRow = c_Mail_Table::row();
        $table->addRow($tableRow);
        foreach ($row as $col) {
            switch ($type) {
            case 'base':
                $tableRow->addColumn(c_Mail_Table::baseColumn($col)->setFontSize('.86em'));
                break;
            case 'dark':
                $tableRow->addColumn(c_Mail_Table::darkColumn($col));
                break;
            case 'orange':
                $tableRow->addColumn(c_Mail_Table::orangeColumn($col));
                break;
            case 'unbordered':
                $tableRow->addColumn(c_Mail_Table::unBorderedColumn($col));
                break;
            }
        }
    }
}


$Mail_Content   .= $oMail_Body->Get_P($Signature, "RIGHT");

$Mail_Body      = str_replace("[[CONTENT]]", $Mail_Content, $Mail_Body);
$Mail_Body      = str_replace("[[BOOKING_CODE]]", $booking->Booking_Code, $Mail_Body);
$Mail_Body      = str_replace("[[MEDIA_HEADER]]", $Content["ResourcesUrl"] . 'mail/Mail_Header.png', $Mail_Body);
// $Mail_Body      = str_replace("[[VOTE_FOR_US_FOOTER]]", $Content["ResourcesUrl"] . 'mail/vote-for-us.png', $Mail_Body);
echo $Mail_Body;

//{{ $Content['Password'] }}
