<?php

require_once __DIR__ . '/vendor/autoload.php';

use Illuminate\Http\Request;
use Illuminate\Contracts\Http\Kernel;

use Illuminate\Support\Facades\DB;

$app = include __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response);

/**
 * AFTER INSERT MIGRATION 65
 */

$passengerList = DB::select('SELECT `Id_Passenger` FROM `t_passenger` ORDER BY `Id_Passenger`');

$query = '';
foreach ($passengerList as $passenger) {
    $query .= 'CALL `sp_passenger_check_booking_tour_passenger_payments`(' . $passenger->Id_Passenger . ', @sts, @cod, @msg);' . "\n";
}

echo $query;

$bookingList = DB::select('SELECT `Id_Booking`, `Id_Admin` FROM `t_booking` WHERE `Id_Admin` <> 0 ORDER BY `Id_Booking`');

$query = '';
foreach ($bookingList as $booking) {
    $query .= 'CALL `sp_booking_assign_insert`(\'\', 2, ' . $booking->Id_Booking . ', ' . $booking->Id_Admin . ', 1, @sts, @cod, @msg, @id);' . "\n";
}

echo $query;
