<?php

namespace App\Providers\UserBooking;

use App\Modules\Booking\Domain\BookingInPerson;
use App\Modules\Booking\Domain\BookingType;

class BookingTypeImage
{
    private static function inPerson()
    {
        return [
            BookingInPerson::BOOKING_TYPE => [
                'text' => '',
                'asset' => ''
            ],
            BookingInPerson::IN_PERSON => [
                'text' =>  'RESERVA OFICINA',
                'asset' => 'Reserva_Usuario_Oficina.png'
            ],
        ];
    }

    private static function typeValues()
    {
        return [
            BookingType::RESERVA_WEB => [
                'text' => 'RESERVA WEB',
                'asset' => 'Reserva_Web.png'
            ],
            BookingType::RESERVA_SISTEMA => [
                'text' => 'RESERVA CORREO',
                'asset' => 'Reserva_Usuario_Correo.png'
            ],
            BookingType::RESERVA_WHATSAPP => [
                'text' => 'RESERVA WHATSAPP',
                'asset' => 'Reserva_Whatsapp.png'
            ],
            BookingType::RESERVA_INSTAGRAM => [
                'text' => 'RESERVA INSTAGRAM',
                'asset' => 'Reserva_Instagram.png'
            ],
            BookingType::RESERVA_PHONE => [
                'text' => 'RESERVA TELÉFONO',
                'asset' => 'Reserva_Phone.png'
            ],
            BookingType::RESERVA_GOOGLE_BUSINESS => [
                'text' => 'RESERVA GOOGLE BUSINESS',
                'asset' => 'Reserva_Google_Business.png'
            ],
            BookingType::RESERVA_MESSENGER => [
                'text' => 'RESERVA MESSENGER',
                'asset' => 'Reserva_Messenger.png'
            ],
            BookingType::RESERVA_OFFICE => [
                'text' => 'RESERVA OFICINA',
                'asset' => 'Reserva_Usuario_Oficina.png'
            ],
            BookingType::RESERVA_VIATOR => [
                'text' => 'RESERVA VIATOR',
                'asset' => 'Reserva_Usuario_Viator.png'
            ],
        ];
    }

    public function __construct()
    {
    }

    public static function getAssetValue($booking)
    {
        $urltype = config('var.PATH_PUBLIC') . "/mail/";

        if ($booking->User_Type === 2) {
            return [
                'text' => 'RESERVA ENDOSADOR',
                'asset' => $urltype . 'Reserva_Endosador.png'
            ];
        }

        if ($booking->Booking_Type === BookingType::RESERVA_WEB) {
            return [
                'text' => BookingTypeImage::typeValues()[$booking->Booking_Type]['text'],
                'asset' => $urltype . BookingTypeImage::typeValues()[$booking->Booking_Type]['asset']
            ];
        }

        if ($booking->Booking_InPerson == BookingInPerson::IN_PERSON) {
            return [
                'text' => BookingTypeImage::inPerson()[$booking->Booking_InPerson]['text'],
                'asset' => $urltype . BookingTypeImage::inPerson()[$booking->Booking_InPerson]['asset']
            ];
        }

        if (isset(BookingTypeImage::typeValues()[$booking->Booking_Type])) {
            return [
                'text' => BookingTypeImage::typeValues()[$booking->Booking_Type]['text'],
                'asset' => $urltype . BookingTypeImage::typeValues()[$booking->Booking_Type]['asset']
            ];
        }
        return [
            'text' => '',
            'asset' => ''
        ];
    }
}
