<?php

namespace App\Providers\ExcelRegistryReport;

use App\Http\Helpers\DateTime;

class RegistryCells {

    protected function printStatus ($status) {
        switch ($status) {
            case 0: return 'ANULADO';
            case 1: return 'PENDIENTE';
            case 2: return 'LISTO';
            case 4: return 'DEVUELTO';
            case 5: return 'INGRESADO';
        }
    }

    protected function printType ($type) {
        switch ($type) {
            case 1: return 'SALIDA';
            case 2: return 'INGRESO';
        }
    }

    public function run ($oRegistry, $oMetadata) {
        $isInput = $oRegistry->Registry_Type == 2;
        $providerName = $isInput ? 'PROVEEDOR' : 'RESPONSABLE';
        return [
            [],
            [],
            [
                [['action' => 'print', 'text' => $oMetadata->title], [ 'action' => 'center'], ['action' => 'bold']],
            ],
            [],
            [
                [[ 'action' => 'print', 'text' => 'FECHA DE DOCUMENTO' ], ['action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => DateTime::dateTimeTransform($oRegistry->Registry_DocumentDate) ]],
                [[ 'action' => 'advance', 'lines' => 1]],
                [[ 'action' => 'print', 'text' => 'SERIE DE DOCUMENTO:' ], [ 'action' => 'bold' ]],
                [[ 'action' => 'advance', 'lines' => 1]],
                [[ 'action' => 'print', 'text' => $oRegistry->Registry_DocumentSerie ]],
            ],
            [
                [[ 'action' => 'print', 'text' => 'NÚMERO DE DOCUMENTO:' ], [ 'action' => 'bold' ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Registry_DocumentNumber ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => 'ESTADO:' ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $this->printStatus ($oRegistry->Registry_Status) ]],
            ],
            [
                [[ 'action' => 'print', 'text' => 'TIPO:' ], [ 'action' => 'bold' ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $this->printType($oRegistry->Registry_Type) ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => "NOMBRE DEL $providerName:" ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Provider_BusinessName ]],
            ],
            [
                [[ 'action' => 'print', 'text' => "DOCUMENTO DEL $providerName:" ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Provider_NoDocument ], ['action' => 'left']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => "TELÉFONO DEL $providerName:" ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Provider_Phone ], ['action' => 'left']],
            ],
            [
                [[ 'action' => 'print', 'text' => "DIRECCIÓN DEL $providerName:" ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Provider_Address ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => 'NOMBRE DEL ALMACÉN:' ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Warehouse_Name ]],
            ],
            [
                [[ 'action' => 'print', 'text' => 'CODIGO DEL ALMACÉN:' ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => $oRegistry->Warehouse_Code ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => 'NOMBRE DEL GRUPO:' ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => isset ($oRegistry->Id_Group) ? $oRegistry->Group_Name : '-' ]],
            ],
            [
                [[ 'action' => 'print', 'text' => 'FECHA DE SALIDA GRUPO:' ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => isset ($oRegistry->Id_Group) ? DateTime::dateTransform($oRegistry->Group_DateStart) : '-' ]],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => 'FECHA DE RETORNO:' ], [ 'action' => 'bold']],
                [[ 'action' => 'advance', 'lines' => 1 ]],
                [[ 'action' => 'print', 'text' => ($isInput ? '-' : ($oRegistry->Id_Admin_Return ? DateTime::dateTransform($oRegistry->Registry_DateReturn) : '-')) ]],
            ],
        ];
    }
    
}