<?php

namespace App\Providers\ExcelProviderServiceReport;

use App\Http\Helpers\DateTime;
use App\Modules\Shared\Domain\ArrayUtils;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

class ProviderServiceCells
{
    private function title($text)
    {
        return [
            ['action' => 'color', 'color' => 'white'],
            ['action' => 'background', 'color' => 'black'],
            ['action' => 'wrap'],
            ['action' => 'border'],
            [
                'action' => 'print',
                'text' => $text
            ],
            ['action' => 'bold']
        ];
    }

    private function column($text)
    {
        return [['action' => 'wrap'], ['action' => 'border'], ['action' => 'print', 'text' => $text]];
    }

    private function columnLeft($text)
    {
        return [['action' => 'wrap'], ['action' => 'left'], ['action' => 'border'], ['action' => 'print', 'text' => $text]];
    }

    private function columnRight($text)
    {
        return [['action' => 'wrap'], ['action' => 'right'], ['action' => 'border'], ['action' => 'print', 'text' => $text]];
    }

    private function columnCenter($text)
    {
        return [['action' => 'wrap'], ['action' => 'center'], ['action' => 'border'], ['action' => 'print', 'text' => $text]];
    }

    private function borderBottom($actions)
    {
        $indexOfBorder = ArrayUtils::findIndex($actions, fn ($cur) => $cur['action'] === 'border');
        if ($indexOfBorder === -1) {
            return array_merge([['action' => 'borderBottom']], $actions);
        } else {
            return array_merge(
                array_slice(
                    $actions,
                    0,
                    $indexOfBorder + 1
                ),
                [['action' => 'borderBottom']],
                array_slice($actions, $indexOfBorder + 1)
            );
        }
    }

    private function searchActionBorder($actions)
    {
        // indexOf
    }

    private function createRows(array $list)
    {
        return ArrayUtils::flatmap(fn ($cur, $index) => $this->borderLastRow($this->joinCM(
            $this->fillGroup($this->mapGroup($index, $cur), $cur),
            $this->mapCMD($cur)
        )), $list);
    }

    private function borderLastRow($list)
    {
        $lastIndex = count($list) - 1;
        $lastRow = $list[$lastIndex];
        foreach ($lastRow as $i => $column) {
            $list[$lastIndex][$i] = $this->borderBottom($column);
        }
        return $list;
    }

    private function joinCM($mapGroup, $mapCMD)
    {
        $turn = [];
        for ($i = 0; $i < count($mapGroup); $i++) {
            $turn[] = array_merge($mapGroup[$i], $mapCMD[$i]);
        }
        return $turn;
    }

    private function mapGroup($index, ProviderServiceGroupDto $cur)
    {
        $guide = $this->findGuide($cur->Providers);
        $cook = $this->findCook($cur->Providers);
        return [
            [
                $this->column($index + 1),
                $this->column($guide ? $guide->Provider_BusinessName : ''),
                $this->column($cook ? $cook->Provider_BusinessName : ''),
                $this->column($cur->Service_Name),
                $this->column(DateTime::dateTransform($cur->Group_DateStart)),
                $this->column(DateTime::dateTransform($cur->Group_DateEnd)),
            ]
        ];
    }

    /** @param array<ProviderServiceProviderDto> $list */
    private function findGuide(array $list)
    {
        return IdTypeProvider::findGuides($list);
    }

    /** @param array<ProviderServiceProviderDto> $list */
    private function findCook(array $list)
    {
        return IdTypeProvider::findCooks($list);
    }

    private function fillGroup($map, $cur)
    {
        return $this->fill($map, count($cur->Passenger));
    }

    private function fill($arr, $length)
    {

        for ($i = count($arr); $i < $length; $i++) {
            $arr[$i] = [
                $this->column(''),
                $this->column(''),
                $this->column(''),
                $this->column(''),
                $this->column(''),
                $this->column(''),
            ];
        }
        return $arr;
    }

    private function mapCMD($cur)
    {
        if (count($cur->Passenger) == 0) {
            return [
                [
                    $this->column(''),
                    $this->column(''),
                    $this->column(''),
                    $this->column(''),
                    $this->column(''),
                    $this->column(''),
                    $this->column(''),
                ]
            ];
        } else {
            return array_map(
                function ($d, $key) {
                    return [
                        $this->columnLeft($key + 1),
                        $this->columnLeft($d->Booking_Code),
                        $this->columnLeft($d->Passenger_Name . ' ' . $d->Passenger_LastName),
                        $this->columnLeft($d->Passenger_NoDocument),
                        $this->columnLeft($d->UserCountry_Name),
                        $this->columnLeft($d->Passenger_Age),
                        $this->columnLeft($d->Passenger_Email),
                        $this->columnCenter($d->Passenger_Gender == 1 ? 'M' : 'F'),
                    ];
                },
                $cur->Passenger,
                array_keys($cur->Passenger)
            );
        }
    }

    public function run($oGroup, $oMetadata)
    {
        return array_merge(
            [
                [
                    $this->title('N'),
                    $this->title('GUÍA'),
                    $this->title('COCINERO'),
                    $this->title('TOUR'),
                    $this->title('FECHA DE SALIDA'),
                    $this->title('FECHA FINAL'),
                    $this->title('CANT. DE PAX'),
                    $this->title('N° DE BOOKING'),
                    $this->title('NOMBRE COMPLETO'),
                    $this->title('PASS / DNI'),
                    $this->title('PAIS'),
                    $this->title('EDAD'),
                    $this->title('CORREO'),
                    $this->title('SEXO'),
                ],
            ],
            $this->createRows($oGroup)
        );
    }
}
