<?php

namespace App\Providers\ExcelGroupReviewsReport;

use App\Providers\ExcelReport\ExcelReportSupport;

class PassengerCells {
    public function run ($oGroup, $oMetadata) {
        $groupTitleLength = 2;
        $result = ExcelReportSupport::create($groupTitleLength);

        $oPassengers = $oGroup->Passenger;

        $result = array_merge ($result, array_reduce ($oPassengers, ['\App\Providers\ExcelGroupReviewsReport\PassengerCells', 'createPassenger'], []));
    
        return $result;
    }

    public static function createPassenger ($carry, $oPassenger) {
        $result = [
            [],
            [
                [['action' => 'print', 'text' => $oPassenger->Passenger_Name . ' ' . $oPassenger->Passenger_LastName], ['action' => 'bold'], ['action' => 'merge', 'lines' => 1]]
            ]
        ];
        $carry = array_merge ($carry, $result, array_reduce ($oPassenger->Review, ['\App\Providers\ExcelGroupReviewsReport\PassengerCells', 'createReview'], []));
        return $carry;
    }

    public static function createReview ($carry, $oReview) {
        $result = [
            [],
            [
                [['action' => 'print', 'text' => $oReview->Question_Name], ['action' => 'center'], ['action' => 'merge', 'lines' => 1]],
            ],
            [
                [['action' => 'print', 'text' => 'SCORE']],
                [['action' => 'print', 'text' => $oReview->PassengerReview_Score]],
            ],
            [
                [['action' => 'print', 'text' => 'COMENTARIO']],
                [['action' => 'print', 'text' => $oReview->PassengerReview_Comment], ['action' => 'wrap']],
            ]
        ];
        $carry = array_merge ($carry, $result);
        return $carry;
    }

}