<?php

namespace App\Providers\ExcelGroupProviderReport;

use App\Providers\ExcelReport\Utils;

class GroupProviderCells
{
    
    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        return Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))));
    }

    private function tableCellLeft($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell())))));
    }
    private function tableCellCenter($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::center($fnPrint(Utils::cell())))));
    }
    private function tableCellRight($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows($data)
    {
        return array_map(fn($b, $index) => $this->getRow($b, $index), $data, array_keys($data));
    }

    private function getRow($provider, $i)
    {
        return array_merge(
            [
                $this->tableCellLeft($i + 1),
                // $this->tableCellLeft($provider->Paquete),
                $this->tableCellLeft($provider->Tour),
                $this->tableCellLeft($provider->IdProv),
                $this->tableCellLeft($provider->Proveedor),
                $this->tableCellLeft($provider->Dia_ida),
                $this->tableCellLeft($provider->Mes_ida),
                $this->tableCellLeft($provider->Anho_ida),
                $this->tableCellLeft($provider->Dia_retorno),
                $this->tableCellLeft($provider->Mes_retorno),
                $this->tableCellLeft($provider->Anho_retorno),
                $this->tableCellLeft($provider->NoDias),
                $this->tableCellLeft($provider->Tiene_Review),
                $this->tableCellLeft($provider->Dia_llenado),
                $this->tableCellLeft($provider->Mes_llenado),
                $this->tableCellLeft($provider->Anho_llenado),
                $this->tableCellLeft($provider->Global_Score),
                $this->tableCellLeft($provider->Guide_Name),
                $this->tableCellLeft($provider->Guide_Score),
                $this->tableCellLeft($provider->Guide_Comment),
                $this->tableCellLeft($provider->SecondGuide_Name),
                $this->tableCellLeft($provider->SecondGuide_Score),
                $this->tableCellLeft($provider->SecondGuide_Comment),
                $this->tableCellLeft($provider->Chef_Name),
                $this->tableCellLeft($provider->Chef_Score),
                $this->tableCellLeft($provider->Chef_Comment),
                $this->tableCellLeft($provider->RestaurantMollepata_Name),
                $this->tableCellLeft($provider->RestaurantMollepata_Score),
                $this->tableCellLeft($provider->RestaurantMollepata_Comment),
                $this->tableCellLeft($provider->RestaurantAguas_Name),
                $this->tableCellLeft($provider->RestaurantAguas_Score),
                $this->tableCellLeft($provider->RestaurantAguas_Comment),
                $this->tableCellLeft($provider->Transport_Name),
                $this->tableCellLeft($provider->Transport_Score),
                $this->tableCellLeft($provider->Transport_Comment),
                $this->tableCellLeft($provider->Horseman_Name),
                $this->tableCellLeft($provider->Horseman_Score),
                $this->tableCellLeft($provider->Horseman_Comment),
                $this->tableCellLeft($provider->CampsSkyCamp_Name),
                $this->tableCellLeft($provider->CampsSkyCamp_Score),
                $this->tableCellLeft($provider->CampsSkyCamp_Comment),
                $this->tableCellLeft($provider->CampsSkyView_Name),
                $this->tableCellLeft($provider->CampsSkyView_Score),
                $this->tableCellLeft($provider->CampsSkyView_Comment),
                $this->tableCellLeft($provider->CampsJungle_Name),
                $this->tableCellLeft($provider->CampsJungle_Score),
                $this->tableCellLeft($provider->CampsJungle_Comment),
                $this->tableCellLeft($provider->CampsAndean_Name),
                $this->tableCellLeft($provider->CampsAndean_Score),
                $this->tableCellLeft($provider->CampsAndean_Comment),
                $this->tableCellLeft($provider->Hotel_Name),
                $this->tableCellLeft($provider->Hotel_Score),
                $this->tableCellLeft($provider->Hotel_Comment),
                $this->tableCellLeft($provider->Recomend_Comment),
                $this->tableCellLeft($provider->RecomendWhy_Comment),
                $this->tableCellLeft($provider->Trip_Advisor),
                $this->tableCellLeft($provider->Google),
                $this->tableCellLeft($provider->Social_Network),
                $this->tableCellLeft($provider->Referencias),
                $this->tableCellLeft($provider->Otros),
                $this->tableCellLeft($provider->Moments_Comment),
                $this->tableCellLeft($provider->Comments_Suggestions),
                $this->tableCellLeft($provider->GPGuide_Name),
                $this->tableCellLeft($provider->GPSecondGuide_Name),
                $this->tableCellLeft($provider->GPChef_Name),
                $this->tableCellLeft($provider->GPRestaurantMollepata_Name),
                $this->tableCellLeft($provider->GPRestaurantAguas_Name),
                $this->tableCellLeft($provider->GPTransport_Name),
                $this->tableCellLeft($provider->GPHorseman_Name),
                $this->tableCellLeft($provider->GPCampsSkyCamp_Name),
                $this->tableCellLeft($provider->GPCampsSkyView_Name),
                $this->tableCellLeft($provider->GPCampsJungle_Name),
                $this->tableCellLeft($provider->GPCampsAndean_Name),
                $this->tableCellLeft($provider->GPHotel_Name),
            ]
        );
    }

    public function run($data, $metadata)
    {
        return array_merge(
            [
                array_merge(
                    array_map([$this,'tableTitle'], [
                        ['N°', 6],
                        ['Tour', 15],
                        ['Id', 8],
                        ['Proveedor', 28],
                        ['D-Ida', 10],
                        ['M-Ida', 10],
                        ['A-Ida', 10],
                        ['D-Retorno', 12],
                        ['M-Retorno', 12],
                        ['A-Retorno', 12],
                        ['Días', 8],
                        ['Tiene Review', 15],
                        ['D-Llenado', 12],
                        ['M-Llenado', 12],
                        ['A-Llenado', 12],
                        ['Global Score', 14],
                        ['Guide_Name', 25],
                        ['Guide_Score', 22],
                        ['Guide_Comment', 45],
                        ['SecondGuide_Name', 25],
                        ['SecondGuide_Score', 22],
                        ['SecondGuide_Comment', 45],
                        ['Chef_Name', 25],
                        ['Chef_Score', 22],
                        ['Chef_Comment', 45],
                        ['RestMollepata_Name', 25],
                        ['RestMollepata_Score', 22],
                        ['RestMollepata_Comment', 45],
                        ['RestAguas_Name', 25],
                        ['RestAguas_Score', 22],
                        ['RestAguas_Comment', 45],
                        ['Transport_Name', 25],
                        ['Transport_Score', 22],
                        ['Transport_Comment', 45],
                        ['Horseman_Name', 25],
                        ['Horseman_Score', 22],
                        ['Horseman_Comment', 45],
                        ['CampsSkyCamp_Name', 25],
                        ['CampsSkyCamp_Score', 22],
                        ['CampsSkyCamp_Comment', 45],
                        ['CampsSkyView_Name', 25],
                        ['CampsSkyView_Score', 22],
                        ['CampsSkyView_Comment', 45],
                        ['CampsJungle_Name', 25],
                        ['CampsJungle_Score', 22],
                        ['CampsJungle_Comment', 45],
                        ['CampsAndean_Name', 25],
                        ['CampsAndean_Score', 22],
                        ['CampsAndean_Comment', 45],
                        ['Hotel_Name', 25],
                        ['Hotel_Score', 22],
                        ['Hotel_Comment', 45],
                        ['Recommend_Comment', 45],
                        ['RecommendWhy_Comment', 45],
                        ['Trip_Advisor', 20],
                        ['Google', 20],
                        ['Social_Network', 20],
                        ['Referencias', 20],
                        ['Otros', 20],
                        ['Moments_Comment', 30],
                        ['Comments_Suggestions', 30],
                        ['GPGuide_Name', 25],
                        ['GPSecondGuide_Name', 25],
                        ['GPChef_Name', 25],
                        ['GPRestMollepata_Name', 25],
                        ['GPRestAguas_Name', 25],
                        ['GPTransport_Name', 25],
                        ['GPHorseman_Name', 25],
                        ['GPCampsSkyCamp_Name', 25],
                        ['GPCampsSkyView_Name', 25],
                        ['GPCampsJungle_Name', 25],
                        ['GPCampsAndean_Name', 25],
                        ['GPHotel_Name', 25],
                    ]),
                ),
            ],
            $this->getAllRows($data)
        );
    }
}
