<?php

namespace App\Modules\WebContactMessageDetail\Application\Update;

use App\Modules\WebContactMessageDetail\Application\Update\UpdateWebContactMessageDetailQueryResponse;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;

final class WebContactMessageDetailUpdater
{
    public function __construct(private WebContactMessageDetailRepository $repository)
    {
    }

    public function __invoke(WebContactMessageDetail $webContactMessageDetail): UpdateWebContactMessageDetailQueryResponse
    {
        return new UpdateWebContactMessageDetailQueryResponse($this->repository->update($webContactMessageDetail));
    }
}
