<?php

namespace App\Modules\WebContactMessage\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateWebContactMessageQuery implements Query
{
    public function __construct(
        private int $id,
        private string $message,
        private int $adults,
        private int $children,
        private int $subscription,
        private int $status,
        private int $idWebContact,
    ) {
    }

    public function message(): string
    {
        return $this->message;
    }

    public function adults(): int
    {
        return $this->adults;
    }

    public function children(): int
    {
        return $this->children;
    }

    public function subscription(): int
    {
        return $this->subscription;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function id(): string
    {
        return $this->id;
    }

    public function idWebContact(): int
    {
        return $this->idWebContact;
    }
}
