<?php

namespace App\Modules\WebContactMessage\Application\ListAll;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;

final class WebContactMessageAllLister
{
    public function __construct(private WebContactMessageRepository $repository)
    {
    }

    public function __invoke(DateStart $dateStart, DateEnd $dateEnd, string $action): ListAllWebContactMessageQueryResponse
    {
        return new ListAllWebContactMessageQueryResponse($this->repository->findAll($dateStart, $dateEnd, $action));
    }
}
