<?php

namespace App\Modules\WebContactMessage\Application\Create;

use App\Modules\WebContactMessage\Application\Create\CreateWebContactMessageResponse;
use App\Modules\WebContactMessage\Domain\WebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;

final class WebContactMessageCreator
{
    public function __construct(private WebContactMessageRepository $repository)
    {
    }

    public function __invoke(WebContactMessage $webContactMessage): CreateWebContactMessageResponse
    {
        return new CreateWebContactMessageResponse($this->repository->insert($webContactMessage));
    }
}
