<?php

namespace App\Modules\WebContact\Domain;

use App\Modules\Country\Domain\IdCountry;

/**
 * Status in the group for filtering and display
 */
class UpdateWebContact
{

    public function __construct(
        private WebContactName $name,
        private WebContactLastName $lastName,
        private WebContactEmail $email,
        private WebContactPhoneCode $phoneCode,
        private WebContactPhone $phone,
        private WebContactStatus $status,
        private ?IdWebContact $id = null,
    ) {
    }

    public function id(): IdWebContact
    {
        return $this->id;
    }

    public function name(): WebContactName
    {
        return $this->name;
    }

    public function lastName(): WebContactLastName
    {
        return $this->lastName;
    }

    public function email(): WebContactEmail
    {
        return $this->email;
    }

    public function phoneCode(): WebContactPhoneCode
    {
        return $this->phoneCode;
    }

    public function phone(): WebContactPhone
    {
        return $this->phone;
    }

    public function status(): WebContactStatus
    {
        return $this->status;
    }
}
