<?php

namespace App\Modules\WebContact\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateWebContactQuery implements Query
{
    public function __construct(
        private string $name,
        private string $lastName,
        private string $email,
        private string $country,
        private string $countryCurrent,
        private string $phoneCode,
        private string $phone,
        private int $status,
        private int $idCountry,
        private int $idCountryCurrent,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function lastName(): string
    {
        return $this->lastName;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function country(): string
    {
        return $this->country;
    }

    public function countryCurrent(): string
    {
        return $this->countryCurrent;
    }

    public function phoneCode(): string
    {
        return $this->phoneCode;
    }

    public function phone(): string
    {
        return $this->phone;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idCountry(): int
    {
        return $this->idCountry;
    }

    public function idCountryCurrent(): int
    {
        return $this->idCountryCurrent;
    }
}
