<?php

namespace App\Modules\TypeBookingAssign\Application\Create;

use App\Modules\TypeBookingAssign\Domain\TypeBookingAssign;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignAbrv;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignName;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignScore;

final class CreateTypeBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private TypeBookingAssignCreator $inserter)
    {
    }

    public function __invoke(CreateTypeBookingAssignQuery $query): CreateTypeBookingAssignResponse
    {
        $model = new TypeBookingAssign(
            new TypeBookingAssignName($query->name()),
            new TypeBookingAssignAbrv($query->abrv()),
            new TypeBookingAssignScore($query->score()),
            new TypeBookingAssignStatus($query->status()),
        );
        return $this->inserter->__invoke($model);
    }
}
