<?php

namespace App\Modules\TourQuestion\Application\List;

use App\Modules\Tour\Domain\IdTour;
use App\Modules\TourQuestion\Domain\TourQuestionRepository;
use App\Modules\TourQuestion\Domain\ListTourQuestion;

final class TourQuestionLister
{
    public function __construct(private TourQuestionRepository $repository)
    {
    }

    public function __invoke(IdTour $idTour)
    {
        return $this->repository->search(new ListTourQuestion($idTour));
    }
}
