<?php

namespace App\Modules\TourQuestion\Application\List;

use App\Modules\TourQuestion\Application\TourQuestionResponse;
use App\Modules\TourQuestion\Application\TourQuestionResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TourQuestion\Domain\RichTourQuestion;

final class ListTourQuestionQueryHandler implements QueryHandler
{
    public function __construct(private TourQuestionLister $lister)
    {
    }

    public function __invoke(ListTourQuestionQuery $query): TourQuestionResponses
    {
        return new TourQuestionResponses(...array_map(
            fn (RichTourQuestion $index) => new TourQuestionResponse(
                $index->id()->value(),
                $index->order()->value(),
                $index->idTour()->value(),
                $index->idQuestion()->value(),
                $index->questionName()->value(),
                $index->questionAbrv()->value(),
                $index->idTypeProvider()->value(),
                json_decode($index->QuestionTypeProviderJSON()->value())
            ),
            $this->lister->__invoke(new IdTour($query->idTour()))
        ));
    }
}
