<?php

namespace App\Modules\Tour\Infraestructure;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Tour\Domain\AcceptTour;
use App\Modules\Tour\Domain\Tour;
use App\Modules\Tour\Domain\TourRepository;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlTourRepository implements TourRepository
{

    public function insert(Tour $value)
    {
        return Requester::requestInsert(
            'CALL `sp_tour_insert`(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->code()->value(),
                $value->name()->value(),
                $value->urlThumbnail()->value(),
                $value->duration()->value(),
                $value->minPax()->value(),
                $value->availability()->value(),
                $value->availabilityStatus()->value(),
                $value->anticipation()->value(),
                $value->anticipationType()->value(),
                $value->color()->value(),
                $value->status()->value(),
                $value->idCategoryTour()->value(),
                $value->idTypeTour()->value(),
                $value->idCountry()->value(),
                $value->idState()->value(),
                $value->idCity()->value(),
            ]
        );
    }

    public function update(Tour $value)
    {
        return Requester::requestUpdate(
            'CALL sp_tour_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->code()->value(),
                $value->name()->value(),
                $value->urlThumbnail()->value(),
                $value->duration()->value(),
                $value->minPax()->value(),
                $value->availability()->value(),
                $value->availabilityStatus()->value(),
                $value->anticipation()->value(),
                $value->anticipationType()->value(),
                $value->color()->value(),
                $value->status()->value(),
                $value->idCategoryTour()->value(),
                $value->idTypeTour()->value(),
                $value->idCountry()->value(),
                $value->idState()->value(),
                $value->idCity()->value(),
            ]
        );
    }

    public function search(StorageCriteria $criteria): array
    {
        return $criteria->run();
    }
}
