<?php

namespace App\Modules\Tour\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class TourUpdaterQuery implements Query
{
    public function __construct(
        private string $id,
        private string $code,
        private string $name,
        private string $urlThumbnail,
        private int $duration,
        private int $minPax,
        private int $availability,
        private int $availabilityStatus,
        private int $anticipation,
        private int $anticipationType,
        private string $color,
        private int $status,
        private int $idCategoryTour,
        private int $idTypeTour,
        private int $idCountry,
        private int $idState,
        private int $idCity,
    ) {
    }

    public function id(): string
    {
        return $this->id;
    }

    public function code(): string
    {
        return $this->code;
    }
    public function name(): string
    {
        return $this->name;
    }
    public function urlThumbnail(): string
    {
        return $this->urlThumbnail;
    }
    public function duration(): int
    {
        return $this->duration;
    }
    public function minPax(): int
    {
        return $this->minPax;
    }
    public function availability(): int
    {
        return $this->availability;
    }
    public function availabilityStatus(): int
    {
        return $this->availabilityStatus;
    }
    public function anticipation(): int
    {
        return $this->anticipation;
    }
    public function anticipationType(): int
    {
        return $this->anticipationType;
    }
    public function color(): string
    {
        return $this->color;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function idCategoryTour(): int
    {
        return $this->idCategoryTour;
    }
    public function idTypeTour(): int
    {
        return $this->idTypeTour;
    }
    public function idCountry(): int
    {
        return $this->idCountry;
    }
    public function idState(): int
    {
        return $this->idState;
    }
    public function idCity(): int
    {
        return $this->idCity;
    }
}
