<?php

namespace App\Modules\Tour\Application;

class TourDaysGenerator
{

    public function __construct()
    {
    }

    public function __invoke($daysInMonth, string $yearMonthStr, $oTour, $availableDays, $locks)
    {
        $arr = self::generateArrayFromDays($daysInMonth);
        $datesOfMonth = self::getDateStringOfMonth($arr, $yearMonthStr);

        $oData  = array();

        $paxdisponible = $oTour[0]->Tour_Availability;
        foreach ($datesOfMonth as $k => $day) {
            $paxdisponible = $oTour[0]->Tour_Availability;
            $paxAmount = 0;
            $lock = 0;

            for ($j = 0; $j < count($availableDays); $j++) {
                if ($availableDays[$j]->BookingTour_DateStart == $day) {
                    $paxdisponible = $paxdisponible - $availableDays[$j]->pax;
                    $paxAmount += $availableDays[$j]->pax;
                }
            }
            
            foreach ($locks as $tourLock) {
                if (self::betweenDates($day, $tourLock->TourLock_DateStart, $tourLock->TourLock_DateEnd)) {
                    $lock = 1;
                }
            }
            $oData[$k] = [
                "date"      => $day,
                "paxFree"   => $paxdisponible,
                'paxAmount' => $paxAmount,
                'paxMin'    => $oTour[0]->Tour_MinPax,
                'lock'      => $lock
            ];
        }
        return $oData;
    }
    
    public static function betweenDates($date1, $date2, $date3)
    {
        $time = strtotime($date1);
        return $time >= strtotime($date2) && $time <= strtotime($date3) ;
    }

    public static function generateArrayFromDays(int $days)
    {
        return range(0, $days - 1);
    }

    public static function getDateStringOfMonth(array $days, string $yearMonthStr)
    {
        return array_map(fn($val) => date("Y-m-d", strtotime($yearMonthStr . ($val + 1))), $days);
    }
}
