<?php

namespace App\Modules\StatusGroupProvider\Domain;


/**
 * Status in the group for filtering and display
 */
class StatusGroupProvider
{

    public function __construct(
        private StatusGroupProviderName $name,
        private StatusGroupProviderAbrv $abrev,
        private StatusGroupProviderColor $color,
        private StatusGroupProviderStatus $status,
        private ?IdStatusGroupProvider $id = null,
    ) {
    }

    public function id(): IdStatusGroupProvider
    {
        return $this->id;
    }

    public function name(): StatusGroupProviderName
    {
        return $this->name;
    }

    public function abrev(): StatusGroupProviderAbrv
    {
        return $this->abrev;
    }

    public function color(): StatusGroupProviderColor
    {
        return $this->color;
    }

    public function status(): StatusGroupProviderStatus
    {
        return $this->status;
    }

}
