<?php

namespace App\Modules\StatusGroup\Application\Delete;

use App\Modules\StatusGroup\Application\Delete\StatusGroupDeleterResponse;
use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\StatusGroup\Domain\StatusGroupRepository;

final class StatusGroupDeleter
{
    public function __construct(private StatusGroupRepository $repository)
    {
    }

    public function __invoke(IdStatusGroup $idStatusGroup): DeleteStatusGroupQueryResponse
    {
        return new DeleteStatusGroupQueryResponse($this->repository->delete($idStatusGroup));
    }
}
