<?php

namespace App\Modules\Shared\Infraestructure;

use App\Modules\Shared\Domain\Transaction;
use Illuminate\Support\Facades\DB;

final class LaravelTransaction implements Transaction
{
    public function begin(): void
    {
        if (env('APP_TEST') !== '1') {
            DB::beginTransaction();
        }
    }
    public function commit(): void
    {
        if (env('APP_TEST') !== '1') {
            DB::commit();
        }
    }
    public function rollback(): void
    {
        if (env('APP_TEST') !== '1') {
            DB::rollBack();
        }
    }
}