<?php

namespace App\Modules\Shared\Domain\Aggregate;

use App\Modules\Shared\Domain\ValueObject\Uuid;

class AggregateAttribute
{
    private string $uniqueId;
    public function __construct(
        private string $attribute,
        private string $objectName,
        private string $column,
        private string $attributeType = 'column'
    ) {
        $this->uniqueId = uniqid('', true);
    }

    public function uniqueId(): string
    {
        return $this->uniqueId;
    }

    public function attribute(): string
    {
        return $this->attribute;
    }

    public function objectName(): string
    {
        return $this->objectName;
    }

    public function column(): string
    {
        return $this->column;
    }

    public function attributeType(): string
    {
        return $this->attributeType;
    }
}
