<?php

namespace App\Modules\ReviewNotification\Application\Reply;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ReplyReviewNotificationQuery implements Query
{
    public function __construct(
        private string $reviewNotificationDescription,
        private int $idGroupPassenger,
        private int $idAdminCreate,
        private int $idReviewNotificationParent
    ) {
    }

    public function getDescription(): string
    {
        return $this->reviewNotificationDescription;
    }
    public function getIdGroupPassenger(): int
    {
        return $this->idGroupPassenger;
    }
    public function getIdAdminCreate(): int
    {
        return $this->idAdminCreate;
    }
    
    public function getIdReviewNotificationParent(): int
    {
        return $this->idReviewNotificationParent;
    }
}
