<?php

namespace App\Modules\ReviewNotification\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ReviewNotificationInserterQuery implements Query
{
    public function __construct(
        private string $reviewNotificationDescription,
        private int $reviewNotificationStatus,
        private int $idGroupPassenger,
        private int $idAdminCreate
    ) {
    }

    public function getDescription(): string
    {
        return $this->reviewNotificationDescription;
    }
    public function getStatus(): int
    {
        return $this->reviewNotificationStatus;
    }
    public function getIdGroupPassenger(): int
    {
        return $this->idGroupPassenger;
    }
    public function getIdAdminCreate(): int
    {
        return $this->idAdminCreate;
    }
}
