<?php

namespace App\Modules\Redistribution\Infraestructure\Validators;

class RedistributionCreate
{

    public const BASIC = [
        'Redistribution_Amount'         => 'required|numeric',
        'Redistribution_Currency'       => 'required|string|max:4',
        'Redistribution_Remark'         => 'string',
        'Redistribution_Status'         => 'required|int',
        'Invoices'                      => 'required|string'
    ];

    public const INVOICES = [
        'Invoices'                          => 'required|array|min:1',
        'Invoices.*.Id_CashMovementDetail'  => 'required|int',
        'Invoices.*.Id_Invoice'             => 'required|int',
        'Invoices.*.Id_CashMovement'        => 'required|int',
        'Invoices.*.Amount'                 => 'required|numeric'
    ];
}
