<?php

namespace App\Modules\Redistribution\Application;

use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Modules\Invoice\Application\Index\IndexInvoiceQuery;
use App\Modules\Invoice\Application\Index\IndexInvoiceResponse;
use App\Modules\Redistribution\Domain\CreateRedistribution;
use App\Modules\Redistribution\Domain\IdRedistribution;
use App\Modules\Redistribution\Domain\RedistributionCreateRepository;
use App\Modules\RedistributionDetail\Domain\CreateRedistributionDetail;
use App\Modules\RedistributionDetail\Domain\RedistributionDetailAmount;
use App\Modules\RedistributionDetail\Domain\RedistributionDetailCreateRepository;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class RedistributionCreator
{

    private RedistributionCreateRepository $repository;
    private RedistributionDetailCreateRepository $repositoryDetail;

    public function __construct(
        RedistributionCreateRepository $repository,
        RedistributionDetailCreateRepository $repositoryDetail,
        private PassengerUpdater $passengerUpdater,
        private QueryBus $queryBus
    ) {
        $this->repository = $repository;
        $this->repositoryDetail = $repositoryDetail;
    }

    public function __invoke(CreateRedistribution $model)
    {
        $response = $this->repository->create($model);
        $detailResponses = [];
        foreach ($model->invoices() as $inv) {
            $detailResponses[] = $this->repositoryDetail->create(
                new CreateRedistributionDetail(
                    new RedistributionDetailAmount($inv->amount()->value()),
                    $inv->idCashMovementDetail(),
                    $inv->idInvoice(),
                    $inv->idCashMovement(),
                    new IdRedistribution($response['Response_Data']['Id'])
                )
            );

            if ($inv->idInvoice()->value() == 0) {
                $cmd = DB::select('CALL sp_cash_movement_detail_index(?)', [$inv->idCashMovementDetail()->value()]);
                $idInvoice = $cmd[0]->Id_Invoice;
            } else {
                $idInvoice = $inv->idInvoice()->value();
            }

            /** @var IndexInvoiceResponse $indexResponse */
            $indexResponse = $this->queryBus->ask(new IndexInvoiceQuery($idInvoice));
            $idPassenger = $indexResponse->response()[0]->Id_Passenger;
            $this->passengerUpdater->updateLockHtlCampBookingPassenger($idPassenger);
        }
        return ['redistribution' => $response, 'redistributionDetail' => $detailResponses];
    }
}
