<?php

namespace App\Modules\QuestionTypeProvider\Infraestructure;

use App\Modules\Question\Domain\IdQuestion;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;
use App\Modules\QuestionTypeProvider\Domain\IdQuestionTypeProvider;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlQuestionTypeProviderRepository implements QuestionTypeProviderRepository
{

    public function find(IdQuestion $idQuestion, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_question_type_provider_list(?,?,@sts,@cod,@msg)',
            [
                $idQuestion->getValue(),
                $action
            ]
        );
    }

    public function index(IdQuestionTypeProvider $id)
    {
        return Requester::requestSelect(
            'CALL sp_question_type_provider_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(QuestionTypeProvider $value)
    {
        return Requester::requestInsert(
            'CALL sp_question_type_provider_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getShow()->value(),
                $value->getForPassenger()->value(),
                $value->getStatus()->value(),
                $value->getIdProvider()->value(),
                $value->getIdTypeProvider()->value(),
            ]
        );
    }

    public function update(QuestionTypeProvider $value)
    {
        return Requester::requestUpdate(
            'CALL sp_question_type_provider_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getShow()->value(),
                $value->getForPassenger()->value(),
                $value->getStatus()->value(),
                $value->getIdProvider()->value(),
                $value->getIdTypeProvider()->value(),
            ]
        );
    }

    public function delete(IdQuestionTypeProvider $id)
    {
        return Requester::requestUpdate(
            'CALL sp_question_type_provider_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
