<?php

namespace App\Modules\QuestionTypeProvider\Application\List;

use App\Modules\Question\Domain\IdQuestion;
use App\Modules\QuestionTypeProvider\Application\List\QuestionTypeProviderListerResponse;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;

final class QuestionTypeProviderLister
{
    public function __construct(private QuestionTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdQuestion $idQuestion, string $action): QuestionTypeProviderListerResponse
    {
        return new QuestionTypeProviderListerResponse($this->repository->find($idQuestion, $action));
    }
}
