<?php

namespace App\Modules\QuestionTypeProvider\Application\Index;

use App\Modules\QuestionTypeProvider\Application\Index\QuestionTypeProviderIndexerResponse;
use App\Modules\QuestionTypeProvider\Domain\IdQuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;

final class QuestionTypeProviderIndexer
{
    public function __construct(private QuestionTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdQuestionTypeProvider $idQuestionTypeProvider): QuestionTypeProviderIndexerResponse
    {
        return new QuestionTypeProviderIndexerResponse($this->repository->index($idQuestionTypeProvider));
    }
}
